package parser;

import extvisitor.*;

/**
 * Represents a token in the grammar, either terminal or non-terminal.
 */
public interface IGrammarSymbol extends IExtVisitorHost<String, IGrammarSymbol>{
  public abstract String getName();
  public abstract <R, P> R execute(IExtVisitor<R, String, P, IGrammarSymbol> algo, P... inps);
  public abstract <R, P> R execute(IGramTypeVisitor<R,P> algo, P... inps);
}
